/*

	GPS Module Drivers, 
	by Mauro Grassi, October 2010.
	Using FSM.
	Accepts (some) NMEA codes...
	
*/

#include "HardwareProfile.h"
#include "spi.h"
#include "mystring.h"
#include "main.h"
#include "gps.h"
#include "serialUSB.h"
#include <math.h>
#include "uart.h"
#include "delay.h"

#pragma udata gpsdata

#pragma code usercode

#if 0
unsigned char disFixGPS(unsigned char c)
{
	c&=0x0F;
	if((c>=0)&&(c<=9))return '0'+c;
	else
	return 'A'+c-0x0A;
}

unsigned char disGetGPS(unsigned char c)
{
	if((c>='0')&&(c<='9'))return c-'0';
	else
	if((c>='A')&&(c<='F'))return c-'A'+10;
	else
	return 0;
}

void sendCGPS(unsigned char c)
{
	putcUART(c);
}
#endif

#if 0
void showGPSPipe(void)
{
	unsigned char c;
	unsigned short length;
	
	putrsUART(" Put: ");
	disWUART(GPSPipePutPtr);
	putrsUART(" Ovf: ");
	disWUART(GPSOverflows);
	putrsUART(" State: ");
	disWUART(GPSPipeState);
	putrsUART(" Mode: ");
	disWUART(GPSMode);
	putrsUART(" CRC Rx: ");
	disWUART(GPSRxCRC);
	putrsUART("\r\n[");	
	length=0;
	while(length<GPSPipePutPtr)
	{
		c=GPSPipe[length];
		if((c>=' ')&&(c<='z'))sendCGPS(c); 
		else 
		{
			sendCGPS('*');
		}
		length++;
	}
	putrsUART("]\r\nLength:  ");
	disWUART(length);
	putrsUART("\r\n");
}
#endif

#if 0
void receiveCharGPS(void)
{
	unsigned char c;
	
	c=RCREG2;
	PIE3bits.RC2IE=0;
	if(GPSMode & 1)
	{
		GPSPipeState=GPS_IDLE_STATE;	
	}
	else
	{	

	switch(GPSPipeState)
	{
			default:
				GPSPipeState=GPS_IDLE_STATE;
			case GPS_IDLE_STATE:
				/* drop any characters until a valid start character is received! */
				GPSRxCRC=0;
				GPSPipePutPtr=0;	
				if(c==GPS_START_CHAR)
				{
					GPSPipeState=GPS_PAYLOAD_STATE;
				}
				break;
			
			case GPS_PAYLOAD_STATE:
				if(c==GPS_START_CHAR)
				{
					/* reset! , this is not supposed to happen */
					GPSPipeState=GPS_IDLE_STATE;
				}
				else
				if(c==GPS_END_PAYLOAD_CHAR)
				{
					GPSPipeState=GPS_FIRST_CRC_CHAR_STATE;
				}
				else
				if(c==GPS_END_CHAR)
				{
					/* this is reached when no CRC is being used, force correct CRC... */
					GPSRxCRC=0;
					GPSPipeState=GPS_IDLE_STATE;
					GPSMode|=1;
				}
				else
				{
					/* add to the CRC */
					if(GPSPipePutPtr<MAX_GPS_PIPE_LENGTH)
					{
						GPSPipe[GPSPipePutPtr++]=c;
						GPSRxCRC^=c;
					}
					else
					{
						GPSPipeState=GPS_IDLE_STATE;
						GPSOverflows++;
					}
				}	
				break;
			
			case GPS_FIRST_CRC_CHAR_STATE:
				if(((c>='0')&&(c<='9'))||((c>='A')&&(c<='F')))
				{
					GPSRxCRC^=((unsigned char)disGetGPS(c)<<4);
					GPSPipeState=GPS_SECOND_CRC_CHAR_STATE;
				}
				else
				{
					GPSPipeState=GPS_IDLE_STATE;
				}
				break;
							
			case GPS_SECOND_CRC_CHAR_STATE:
				if(((c>='0')&&(c<='9'))||((c>='A')&&(c<='F')))
				{
					GPSRxCRC^=(unsigned char)disGetGPS(c);
					GPSPipeState=GPS_IDLE_STATE;
					GPSMode|=1;
				}
				else
				{
					/* reset! , this is not supposed to happen */
					GPSPipeState=GPS_IDLE_STATE;
				}
				break;
	}
	}
	PIR3bits.RC2IF=0;
	PIE3bits.RC2IE=1;
}
#endif

#if 0
void sendCharGPS(unsigned char c)
{
	/* send c and add to the running CRC */
	GPSTxCRC^=c;
	sendCGPS(c);
}

void startGPSCommand(unsigned rom const char* cmd)
{
	GPSTxCRC=0;
	sendCGPS(GPS_START_CHAR);
	while((*cmd)!='\0')
	{
		sendCharGPS((*cmd));
		cmd++;
	}
}

void continueGPSCommand(unsigned char* instring)
{
	while((*instring)!='\0')
	{
		sendCharGPS(*instring);
		instring++;
	}
}

void endGPSCommand(void)
{
	sendCGPS(GPS_END_PAYLOAD_CHAR);
	sendCGPS(disFix(GPSTxCRC>>4));
	sendCGPS(disFix(GPSTxCRC));
	sendCGPS(0x0D);
	sendCGPS(GPS_END_CHAR);
}

void sendDecimalNumberGPSCommand(long num, unsigned int charToPrint)
{
	if(num<0)
	{
		sendCharGPS('-');
		num=-num;
	}
	myultoa(num, tempString, charToPrint);
	continueGPSCommand(tempString);
}

void PSRF103Command(unsigned char msgtype, unsigned char query, unsigned char rate, unsigned char chksum)
{
	startGPSCommand((unsigned rom const char*)"PSRF103,");
	sendDecimalNumberGPSCommand(msgtype, 2);
	sendCGPS(',');
	sendDecimalNumberGPSCommand(query, 2);
	sendCGPS(',');
	sendDecimalNumberGPSCommand(rate, 2);
	sendCGPS(',');
	sendDecimalNumberGPSCommand(chksum, 2);
	endGPSCommand();
}

void initGPSModule(void)
{
	/* Turn Off All Messages First */
	startGPSCommand((unsigned rom const char*)"PSRF100,01,9600,08,01,00");
	endGPSCommand();
	startGPSCommand((unsigned rom const char*)"PSRF103,00,00,00,00");
	endGPSCommand();
	startGPSCommand((unsigned rom const char*)"PSRF103,01,00,00,00");
	endGPSCommand();
	startGPSCommand((unsigned rom const char*)"PSRF103,02,00,00,00");
	endGPSCommand();
	startGPSCommand((unsigned rom const char*)"PSRF103,03,00,00,00");
	endGPSCommand();
	startGPSCommand((unsigned rom const char*)"PSRF103,04,00,00,00");
	endGPSCommand();
	startGPSCommand((unsigned rom const char*)"PSRF103,05,00,00,00");
	endGPSCommand();
	startGPSCommand((unsigned rom const char*)"PSRF103,00,00,01,01");
	endGPSCommand();
}

void initGPSBaudRate(float baudRequired)
{
	unsigned int baudRate;
	if(baudRequired<=0.0)baudRequired=300.0;
	baudRate=(unsigned int)((float)GetSystemClock()/(4.0*baudRequired));	
	SPBRGH2=(unsigned char)(baudRate>>8);
	SPBRG2=(unsigned char)(baudRate);
}

void initGPS(float baudRequired)
{	
	/* Initialize the UART */
	#if(USE_PMDIS)
		PMDIS0bits.UART2MD=0;
	#endif
	RPOR1=6; 						/* EUSART 2 Tx pin on PPS pin... */
	RPINR16=0;
	TRISAbits.TRISA1=0;
	TRISAbits.TRISA0=1;
	BAUDCON2=0x38;					/* RxPolarity=1 BRG16=1 Baud Rate= FOSC/(4(n+1)) */
	initGPSBaudRate(baudRequired);
	TXSTA2=0x24;					/* TxEN=1 and BRGH=1 high speed BRG */
	RCSTA2=0x90;					/* Serial Port Enable=1 and RxEN=1 */
	GPSPipePutPtr=0;
	GPSTxCRC=0;
	GPSRxCRC=0;
	GPSOverflows=0;
	GPSMode=0;
	GPSPipeState=GPS_IDLE_STATE;
	initGPSModule();
	IPR3bits.RC2IP=0;
	PIE3bits.RC2IE=1;
	PIR3bits.RC2IF=0;
}	
#endif

void outputNMEAX(unsigned char* in, unsigned char* out, unsigned char* outIndex, unsigned char todoOut, unsigned char outSize)
{
	if(((*outIndex)+todoOut)<=(outSize))
	{
		/* assumes little endianness */
		while(todoOut>0)
		{
			*(out+(*outIndex))=*in++;
			(*outIndex)++;
			todoOut--;
		}	
	}
}

unsigned char* getNMEAX(unsigned char* in, unsigned char* out, unsigned char todoOut)
{
	while(todoOut>0)
	{
		*out=*in;
		out++;
		in++;
		todoOut--;
	}	
	return in;
}

unsigned char matchNMEAString(unsigned char* cmd, const rom unsigned char* cmdRom, unsigned char* src, unsigned char* out, unsigned char* cmdIndex, unsigned char* srcIndex, unsigned char* outIndex, unsigned char srcSize, unsigned char outSize)
{
	/*	 
		Matches a NMEA String... Returns 1 if matched, 0 otherwise...				
		The Commands Are Always Comma Separated Commands, As Follows:
		's' + literal string 		    :	match the literal string exactly (comma marks the end and can't be matched in the string, use the 'c' option to match the comma)...
		'c' + char 						:   match the character exactly...
		'$'								:   match any character & store it...
		'@'								:   match any character but do not store the result...
		'd' + n (n:1-9)					:   match up to n decimal digits and store the output...
		'x' + n (n:1-9)					:   match up to n hex digits and store the output...
		'\0'							:   end the command string...
		'f' 							:	match a floating point number...	
	*/
	
    unsigned char c;
	unsigned char s;
	unsigned char i;
	unsigned char matched;
	unsigned char nextCmd;

	int			  base;
	float		  x;
	float		  mul;
		
	*cmdIndex=0;
	*srcIndex=0;
	*outIndex=0;
	matched=1;
	do
	{
		/* Move Source To The Next Comma Separated Field */
		do
		{
			if(srcSize>0)
			{
				c=*(src+(*srcIndex));
				if(c==',')
				{
					/* a blank field */
					(*srcIndex)++;
					srcSize--;
				}
			}
			else
			{
				c='\0';
			}
			
		}
		while(c==',');
		
		/* Get The Next Command */
		if(cmd)
		{
			nextCmd=*(cmd+(*cmdIndex));
		}
		else
		{
			nextCmd=*(cmdRom+(*cmdIndex));
		}
		(*cmdIndex)++;		
			
		switch(nextCmd)
		{
			default:
			case '\0':
				break;
			
			case 's':
				/* Match a String Exactly */
				do
				{
					if(cmd)
					{
						c=*(cmd+(*cmdIndex));
					}
					else
					{
						c=*(cmdRom+(*cmdIndex));
					}
					(*cmdIndex)++;
					if(c!=',')
					{
						if(srcSize>0)
						{
							s=*(src+(*srcIndex));
							(*srcIndex)++;
							srcSize--;
						}
						else
						{
							s=',';
						}	
						if(s!=c)
						{
							matched=0;
						}
					}	
				}
				while((matched)&&(c!=','));	
				break;
			
			case 'c':
				/* Match a single character */
				if(cmd)
				{
					c=*(cmd+(*cmdIndex));
				}
				else
				{
					c=*(cmdRom+(*cmdIndex));
				}	
				(*cmdIndex)++;
				if(srcSize>0)
				{
					s=*(src+(*srcIndex));
					(*srcIndex)++;
					srcSize--;
				}
				else
				{
					s='\0';
				}	
				if(s!=c)
				{
					matched=0;
				}
				break;
			
			case '$':
			case '@':
				/* Match Any Single Character */
				c=(unsigned char)*(src+(*srcIndex));
				(*srcIndex)++;
				if(nextCmd=='$')outputNMEAX(&c, out, outIndex, 1, outSize);
				break;
			
			case 'd':
			case 'x':
				if(nextCmd=='d')base=10; else base=16;
				x=0;
				if(cmd)
				{
					c=*(cmd+(*cmdIndex));
				}
				else
				{
					c=*(cmdRom+(*cmdIndex));
				}
				(*cmdIndex)++;
				if((c>='0')&&(c<='9'))
				{
				 c=c-'0';
				}
				else
				{
				 c=0;
				}	
				/* c is the number of digits to match */
				i=0;
				while((matched)&&(i<c))
				{
					if(srcSize>0)
					{
						s=*(src+(*srcIndex));
						(*srcIndex)++;
						srcSize--;
					}
					else
					{
						s='\0';
					}	
	
					if((s>='0')&&(s<='9'))
					{
						x*=base;
						x+=(s-'0');
					}
					else
					{
						matched=0;
					}
					i++;
				}
				switch(c)
				{
					case 1:
					case 2:
						i=(unsigned char)x;
						outputNMEAX((unsigned char*)&i, out, outIndex, 1, outSize);
						break;
					
					default:
						outputNMEAX((unsigned char*)&x, out, outIndex, sizeof(float), outSize);
						break;
				}
				break;
			
			case 'f':
				x=0;
				mul=0;
				i=1;
				while(i)
				{
					if(srcSize>0)
					{
						s=*(src+(*srcIndex));
						(*srcIndex)++;
						srcSize--;
					}
					else
					{
						s='\0';
					}
					
					if((s>='0')&&(s<='9'))
					{
						x*=10;
						x+=(s-'0');
						mul*=10;
					}
					else
					if(s=='.')
					{
						mul=1;
					}
					else
					{
						i=0;
					}
				}
				if(mul>0)x=x/mul;
				outputNMEAX((unsigned char*)&x, out, outIndex, sizeof(float), outSize);
				break;
		}
	}
	while((matched)&&(nextCmd!='\0'));
	return (*outIndex);
}
